################################################################################
# Shoutbox.pl:     Part of the Shoutbox Mod for YaBB			       #
# Copyright:       2005 Andrew Aitken (LoonyPandora)			       #
# Version:         Shoutbox 2.3.1 b0.6					       #
# Released:        29th January, 2009					       #
# Distributed By:  http://www.boardmod.org				       #
# 2.3.1 update by: Batchman, Derek Barnstorm, D0T-C0M, Driven, with permission #  ################################################################################

$shoutadminplver = 'Shoutbox Mod for YaBB 2.3.1 beta 0.6';
if ($action eq 'detailedversion') { return 1; }

LoadLanguage("Shoutbox");

sub my_wrap3 {
	$message =~ s~(<.*>)*(\S{0,14})(\S*)?(<.*>)*~$1$2 $3$4~gi;
	$message =~ s~(<.*>)?(\S{0,14})(\S*)(<\/\S*>)~$1$2 $3$4~gi;
	$message =~ s~\s+~ ~gi;
}

sub RemoveShouts {

	(@delshouts) = split(/,\s*/, $FORM{'delcheckbox'});

	fopen(SHOUTS, "+<$vardir/shouts.txt");
	@shouts = <SHOUTS>;

	foreach $shout_to_delete (@delshouts) {
		if ($iamadmin || $iamgmod && $allow_mod == 1) {

			$line_count = 0;

			foreach $shoutline (@shouts) {
				chomp;
				($shout_time, $dummy, $dummy, $dummy) = split(/[\|]/, $shoutline);

				unless ($shout_time != $shout_to_delete) {
					$line_number = $line_count;
					last;
				}
				$line_count++;
			}
			$shouts[$line_number] = '';
		}
	}

	seek SHOUTS, 0, 0;
	truncate SHOUTS, 0;
	print SHOUTS @shouts;
	fclose(SHOUTS);

	$yymain .= qq~<center>$shout_txt{'42'}<br /><br /><a href="$boarddir/AdminIndex.pl?action=shoutadmin">$shout_txt{'44'}</a></center>~;
	&AdminTemplate;
}

sub ShoutSettings2 {
	&is_admin_or_gmod;

	my @onoff = qw/enable_ubbc enable_censor reverse_post/;

	# Set as 0 or 1 if box was checked or not
	my $fi;
	map { $fi = lc $_; ${$_} = $FORM{$fi} eq 'on' ? 1 : 0; } @onoff;

	$min_posts             = $FORM{'min_posts'}             || "0";
	$maximum_shouts        = $FORM{'maximum_shouts'}        || "250";
	$max_disp_shouts       = $FORM{'max_disp_shouts'}       || "20";
	$max_shout_length      = $FORM{'max_shout_length'}      || "500";
	$max_admin_disp_shouts = $FORM{'max_admin_disp_shouts'} || "30";
	$delete_delay          = $FORM{'delete_delay'}          || "0";
	$censor_lang           = $FORM{'censor_lang'}           || "English";

	my $setfile = qq~
###############################################################################
# shoutsettings.txt:  Part of the Shoutbox Mod for YaBB
# Copyright:          2003-2004 Andrew Aitken (LoonyPandora)
# Version:            Shoutbox 0.7
# Released:           27th October, 2005
# Distributed By:     http://www.boardmod.org
# 		      http://www.loonypandora.com
###############################################################################

\$min_posts = "$min_posts";
\$maximum_shouts = "$maximum_shouts";
\$max_disp_shouts = "$max_disp_shouts";
\$max_shout_length = "$max_shout_length";
\$max_admin_disp_shouts = "$max_admin_disp_shouts";
\$delete_delay = "$delete_delay";
\$enable_ubbc = "$enable_ubbc";
\$enable_censor = "$enable_censor";
\$censor_lang = "$censor_lang";
\$reverse_post = "$reverse_post";

1;
~;

	fopen(FILE, ">$vardir/shoutsettings.txt");
	print FILE $setfile;
	fclose(FILE);

	$yySetLocation = qq~$boarddir/AdminIndex.pl?action=shoutadmin~;
	&redirectexit;
}

sub ShoutAdmin {
	if (-e "$vardir/shoutsettings.txt") { require "$vardir/shoutsettings.txt"; }

	if ($enable_ubbc)   { $enable_ubbc_check   = q~ checked="checked"~; }
	if ($enable_censor) { $enable_censor_check = q~ checked="checked"~; }
	if ($reverse_post) { $reverse_post_check = q~ checked="checked"~; }

	opendir(dir, $langdir);
	my @lfilesanddirs = readdir(dir);
	close(dir);
	$drawnldirs .= qq~<option value=""></option>~;
	foreach $fld (@lfilesanddirs) {
		if (-d "$langdir/$fld" && $fld =~ m^\A[0-9a-zA-Z_\#\%\-\:\+\?\$\&\~\,\@/]+\Z^) {
			if ($censor_lang eq $fld) { $drawnldirs .= qq~<option value="$fld" selected="selected">$fld</option>~; }
			else { $drawnldirs .= qq~<option value="$fld">$fld</option>~; }
		}
	}

	$yymain .= qq~
	<form action="$adminurl?action=shoutsettings2" method="post">
	<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
	<table width="100%" cellspacing="1" cellpadding="4">
     <colgroup>
			<col width="50%" />
			<col width="50%" />
     </colgroup>
     <tr valign="middle">
       <td align="left" class="titlebg" colspan="2"><img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$shout_txt{'41'}</b></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'18'}</td>
    <td align="left" class="windowbg2"><input type="text" name="min_posts" size="5" value="$min_posts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'19'}</td>
    <td align="left" class="windowbg2"><input type="text" name="maximum_shouts" size="5" value="$maximum_shouts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'20'}</td>
    <td align="left" class="windowbg2"><input type="text" name="max_disp_shouts" size="5" value="$max_disp_shouts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'21'}</td>
    <td align="left" class="windowbg2"><input type="text" name="max_shout_length" size="5" value="$max_shout_length" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'22'}</td>
    <td align="left" class="windowbg2"><input type="text" name="max_admin_disp_shouts" size="5" value="$max_admin_disp_shouts" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'23'}</td>
    <td align="left" class="windowbg2"><input type="text" name="delete_delay" size="5" value="$delete_delay" /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'24'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_ubbc" $enable_ubbc_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'25'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="enable_censor" $enable_censor_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'40'}</td>
    <td align="left" class="windowbg2"><input type="checkbox" name="reverse_post" $reverse_post_check /></td>
     </tr>
     <tr valign="middle">
    <td align="left" class="windowbg2">$shout_txt{'26'}</td>
    <td align="left" class="windowbg2"><select name="censor_lang">$drawnldirs</select></td>
     </tr>
     <tr valign="middle">
     <td align="center" class="catbg" colspan="2"><input type="submit" value="$reftxt{'4'}" /></td>
     </tr>
   </table>
  </div>
 </form>
<br /><br />
~;

	$start = $INFO{'start'} || 0;

	fopen(SHOUTS, "$vardir/shouts.txt");
	@shouts = <SHOUTS>;
	fclose(SHOUTS);

	$number_of_shouts = $#shouts;
	$skip_shouts      = $start;
	$counter          = 0;
	$displayedcounter = 0;

	$yymain .= qq~
		<script language="JavaScript1.2" type="text/javascript">
		function SelPage(pstart) {
			location.href="$adminurl?action=shoutadmin;start="+pstart;
		}
		</script>
<form action="$adminurl?action=removeshouts" name"removeshouts" method="post">
<div class="bordercolor" style="padding: 0px; width: 99%; margin-left: 0px; margin-right: auto;">
  <table width="100%" cellspacing="1" cellpadding="4">
     <colgroup>
			<col width="90%" />
			<col width="10%" />
     </colgroup>
	<tr>
	  <td align="left" class="titlebg" colspan="4"><img src="$imagesdir/preferences.gif" alt="" border="0" /><b>$shout_txt{'27'}</b></td>
	</tr>~;

	foreach $shoutline (@shouts) {
		if ($counter >= $skip_shouts && $displayedcounter < $max_admin_disp_shouts) {
			chomp @shouts;
			($shout_time, $shout_displayname, $shout_username, $shout_message) = split(/[\|]/, $shoutline);

			# Censor the posts, and display names
			if ($enable_ubbc) {
				&LoadCensorList;
				$shout_displayname = &Censor($shout_displayname);
				$shout_message     = &Censor($shout_message);
			}

			# Do UBBC on the Shout
			$message = $shout_message;
			&wrap;
			if ($enable_ubbc) {
				if (!$yyYaBBCloaded) {
					require "$sourcedir/YaBBC.pl";
				}
				&DoUBBC;
			}
			&my_wrap3;
			if (length($message) > $max_shout_length) { $message = substr($message, 0, $max_shout_length); }
			$shout_message = $message;

			# Get the alternating backgrounds
			if ($counter % 2) {
				$class = 'windowbg';
			} else {
				$class = 'windowbg2';
			}

			$deletelink = qq~<input type="checkbox" name="delcheckbox" value="$shout_time" />~;

			# Format the date for the title attribute
			$shout_time = &shout_timeformat($shout_time);

			$yymain .= qq~<tr><td class="$class" title="$shout_time">
<b><a href="$scripturl?action=viewprofile;username=$shout_username">$shout_displayname:</a></b> $shout_message
</td><td class="$class" title="$shout_time" align="center"  colspan="3">$deletelink</td></tr>~;

			$displayedcounter++;
		}
		$counter++;
	}

	&Paginate;

	$yymain .= qq~
	</td></tr>
	<tr>
<td class="catbg">$pageindex</td>
<td class="catbg" colspan="3" align="right">
<input type="submit" name="Delete" value="$shout_txt{'43'}" tabindex="5" />
</td></tr>
  </table>
</div>
</form>
~;

	$action_area = "shoutadmin";
	&AdminTemplate;
}

sub Paginate {

	# Build the page links list.
	$postdisplaynum = 3;                                                                 # max number of pages to display
	$max            = $number_of_shouts + 1;
	$start          = $INFO{'start'} || 0;
	$start          = $start > $number_of_shouts ? $number_of_shouts : $start;
	$start          = (int($start / $max_admin_disp_shouts)) * $max_admin_disp_shouts;
	$tmpa           = 1;
	$tmpx           = int($max / $max_admin_disp_shouts);
	if ($start >= (($postdisplaynum - 1) * $max_admin_disp_shouts)) { $startpage = $start - (($postdisplaynum - 1) * $max_admin_disp_shouts); $tmpa = int($startpage / $max_admin_disp_shouts) + 1; }
	if ($max >= $start + ($postdisplaynum * $max_admin_disp_shouts)) { $endpage = $start + ($postdisplaynum * $max_admin_disp_shouts); }
	else { $endpage = $max }
	if ($startpage > 0) { $pageindex = qq~<a href="$adminurl?action=shoutadmin;start=0"><b>1</b></a>&nbsp;...&nbsp;~; }
	if ($startpage == $max_admin_disp_shouts) { $pageindex = qq~<a href="$adminurl?action=shoutadmin;start=0"><b>1</b></a>&nbsp;~; }

	for ($counter = $startpage; $counter < $endpage; $counter += $max_admin_disp_shouts) {
		$pageindex .= $start == $counter ? qq~<b>$tmpa</b>&nbsp;~ : qq~<a href="$adminurl?action=shoutadmin;start=$counter"><b>$tmpa</b></a>&nbsp;~;
		$tmpa++;
	}

	$tmpx    = $max - $max_admin_disp_shouts;
	$outerpn = int($tmpx / $max_admin_disp_shouts) + 0;
	$lastpn  = int($number_of_shouts / $max_admin_disp_shouts) + 1;
	$lastptn = ($lastpn - 1) * $max_admin_disp_shouts;
	if ($endpage < $max - ($max_admin_disp_shouts)) { $pageindexadd = qq~&nbsp;...&nbsp;~; }
	if ($endpage != $max) { $pageindexadd .= qq~&nbsp;<a href="$adminurl?action=shoutadmin;start=$lastptn"><b>$lastpn</b></a>~; }
	$pageindex .= $pageindexadd;
}

sub shout_timeformat {
	$oldformat = $_[0];
	if ($oldformat eq '' || $oldformat eq "\n") { return $oldformat; }
	$dontusetoday = $_[1] + 0;
	if ($usercheck{'timeselect'} > 0) { $mytimeselected = $usercheck{'timeselect'}; }
	else { $mytimeselected = $timeselected; }
	my ($newsecond, $newminute, $newhour, $newday, $newmonth, $newyear, $newweekday, $newyearday, $newisdst) = localtime($oldformat + (3600 * $usercheck{'timeoffset'}));

	$newmonth++;
	$newweekday++;
	$newyear += 1900;
	$newshortyear = substr($newyear, 2, 2);
	if ($newmonth < 10) { $newmonth = "0$newmonth"; }
	if ($newday < 10 && $mytimeselected != 4) { $newday = "0$newday"; }
	if ($newhour < 10)   { $newhour   = "0$newhour" }
	if ($newminute < 10) { $newminute = "0$newminute"; }
	if ($newsecond < 10) { $newsecond = "0$newsecond"; }
	$newtime        = $newhour . ":" . $newminute . ":" . $newsecond;
	$usertimeoffset = $timeoffset + $usercheck{'timeoffset'};
	($secx, $minx, $hourx, $dd, $mm, $yy, $tmpx, $tmpx, $tmpx) = localtime(time + (3600 * $usertimeoffset));
	$mm = $mm + 1;
	$yy = ($yy % 100);

	$newmonth--;
	$ampm = $newhour > 11 ? 'pm' : 'am';
	$newhour2 = $newhour % 12 || 12;
	$newmonth2 = $months[$newmonth];
	if ($newday > 10 && $newday < 20) { $newday2 = 'th'; }
	elsif ($newday % 10 == 1) { $newday2 = 'st'; }
	elsif ($newday % 10 == 2) { $newday2 = 'nd'; }
	elsif ($newday % 10 == 3) { $newday2 = 'rd'; }
	else { $newday2 = 'th'; }
	$newformat = qq~$newmonth2 $newday$newday2, $newyear, $newhour2:$newminute$ampm~;
	if ($mm == $newmonth + 1 && $dd == $newday && $yy == $newshortyear && $dontusetoday == 0) { $newformat = qq~$shout_txt{'28'} $shout_txt{'29'} $newhour2:$newminute$ampm~; }
	return $newformat;
}

1;
